	.INCLUDE "EQUATES.S"
****
*
* MAZE BANK
*
* DUNGEON 2600 PROGRAM
*
* WRITTEN BY ADAM CLAYTON
* DEVELOPED BY SCULPTURED SOFTWARE
* COPYRIGHT 1987 ATARI
* 
****
*
* BANK SWITCHING PORTION
*
****
	ORG	$FFE8
KBANK:
	LDA	$FFF6		;JUMP TO BANK 0 (KERNAL BANK)
****
*
* ENTRY POINT FROM BANK 2 (LOGIC BANK)
*
****
	JMP	BLSTUFF 	;VECTOR FOR NORMAL BANK SWITCH
****
*
* JUMP FOR WRONG BANK
*
****
	ORG	$FFF0
MFIX:
	LDA	$FFF9
	JMP	MFIX
****
*
* RESET VECTORS
*
****
	ORG	$FFF8
	DC.B	$00,$00
	DC.W	MFIX		;IF WRONG BANK GOTO CORRECT ONE
	DC.W	MFIX
	DC.W	MFIX

	ORG	$F100
****
*
* PROGRAM TO CHECK BULLET AGAINST PF, OBJECTS, AND ENEMY PLAYERS
* 
****
BLSTUFF:
	LDA	FRMCNT
	AND	#$01
	EOR	#$01
	STA	TEMP		;CONTAINS BULLET TO CHECK
	TAX
	LDA	CXBLPF		;CHECK COLLISION REGISTER
	STA	CXCLR
	BPL	.2
.1:
	JMP	.16
.2:
	LDA	HMBALL+1,X	;SET UP NEWX, NEWY STUFF
	STA	NEWX1
	LDA	BALCNT+1,X
	STA	NEWY1
	LDA	ADIR,X		;GET DIRECTION OF BULLET
	LDY	#$09
	AND	#$0A		;CHECK IF BULLET MOVING
	BEQ	.1		;IF NOT THEN STOP BULLET
	LDX	NEWY1
.3:
	TXA
	SEC
	SBC	PLVER+SARA,Y	;CHECK VERTICAL 
	BCS	.5
	CMP	#$FB
	BCS	.6
.4:
	DEY
	CPY	#$01
	BNE	.3
	JMP	.17
.5:
	CMP	#$06
	BCS	.4
.6:
	LDA	NEWX1
	SEC
	SBC	PLHOR+SARA,Y
	BCS	.7
	CMP	#$FA
	BCS	.8
	BCC	.4
.7:
	CMP	#$07
	BCS	.4
.8:
	LDA	PLTYP+SARA,Y
	BPL	.9
	JMP	.17
.9:
	CMP	#$10
	BCS	.11		;IF ENEMY PLAYER JUMP
	CMP	#$0F
	BEQ	.10
	JMP	.16		;IF OBJECT BUT NOT POISON THEN STOP BULLET
.10:
* POISON
	LDX	#$01
	STX	SOUND0+1
	LDA	LEVEL
	LSR
	AND	#$0C
	STA	TEMP+1
	LDA	PLAY
	LSR
	ORA	TEMP+1
	TAX
	LDA	GENSPEED,X
	AND	RANDOM		;USE RANDOM NUMBER FOR KILL
	BEQ	.101
	JMP	.16
.101:
	LDA	PLREF+SARA,Y
	LSR
	LSR
	LSR
	LSR
	STA	PLTYP,Y
	BNE	.102		;IF GENERATOR GOES TO NOTHING THEN ERASE
	STA	PLVER,Y
.102:
	LDA	#$10		;IF KILL GENERATOR THEN ADD SCORE 100 PTS
	STA	TEMP+1
	BNE	.15		;JUMP TO ADD SCORE
* ENEMY GUYS
.11:
	LDX	#$01
	STX	SOUND0+1
	LDX	TEMP
	LDA	HEALTH,X	;IF DAGGER BIT SET THEN AUTO MUTATE GUY 
	AND	#$20
	BNE	.12
	LDA	PLREF+SARA,Y	;CHECK IF MORE HITS LEFT
	TAX
	AND	#$03
	BEQ	.12
	DEX
	TXA
	STA	PLREF,Y 	;IF SO DECREMENT THEM
	JMP	.16
.12:
	LDA	LEVEL		;PUT IN HITS FOR MUTATED GUY
	LSR
	AND	#$0C
	STA	TEMP+1
	LDA	PLAY
	LSR
	ORA	TEMP+1
	TAX
	LDA	MUTATE,X
	TAX
	LDA	GENGUY,X
	AND	#$0F
	ORA	PLREF+SARA,Y	;PUT OLD ENEMY DIRECTION BACK IN
	STA	PLREF,Y
.13:
	LDA	PLTYP+SARA,Y	;MUTATE PLAYER TO LOWER FORM
	LSR
	LSR
	LSR
	LSR
	TAX
	LDA	SCORES-3,X	  ;ADD SCORE 
	STA	TEMP+1
	LDA	#$86
	DEX
	CPX	#$02
	BEQ	.14
	TXA
	ASL
	ASL
	ASL
	ASL
	STA	TEMP+3
	LDA	PLTYP+SARA,Y
	AND	#$0F
	ORA	TEMP+3		;PUT LOW NIBBLE OF TYPE WITH MUTATED ONE
.14:	
	STA	PLTYP,Y
.15:
	LDX	TEMP
	SED
	LDA	SCORLO,X
	CLC
	ADC	TEMP+1
	STA	SCORLO,X
	LDA	SCORHI,X
	ADC	#$00
	STA	SCORHI,X
	CLD
.16:
	LDX	TEMP
	LDA	#$00
	STA	BALCNT+1,X
	LDA	ADIR,X
	AND	#$F0
	STA	ADIR,X
.17:
****
*
* MAZE PROGRAM TO UPDATE INFORMATION INTO RAMPF0-2
*
****
UPPF:
	JSR	UPLAY
*	 JSR	 UPCOLOR	 ;HACK TO CHANGE BK COLOR
	LDA	CONTRL
	AND	#$0F
	CMP	#$02
	BNE	.1
	JMP	ERAGUYS
.1:
	CMP	#$05
	BNE	.2
	JMP	PUTGUYS
.2:
	LDA	FRAME		;ONLY ON FRAME ONE
	CMP	#$01
	BEQ	.3
	JMP	KBANK
.3:	  
	LDA	ROOM
	ASL
	TAX
	LDA	BTYPE,X
	TAY
	AND	#$0F
	STA	TEMP+2		;GET EACH BLOCK TYPE FOR ROOM TEMP+3-5
	TYA
	LSR
	LSR
	LSR
	LSR
	STA	TEMP+1
	INX
	LDA	BTYPE,X
	TAY
	AND	#$0F
	STA	TEMP+4
	TYA
	LSR
	LSR
	LSR
	LSR
	STA	TEMP+3
	LDA	WINDOW
	CLC
	ADC	#79		;GET LOCATION OF BOTTOM OF WINDOW
	TAY
	LSR
	LSR
	AND	#$0F
	TAX
	LDA	JLO,X		;GET ADDRESSES TO JUMP TO
	STA	ADPF0
	LDA	JHI,X
	STA	ADPF0+1
	TYA
	ROL
	ROL
	ROL
	AND	#$03
	STA	TEMP		;STORE 1ST BLOCK NUMBER 0-3
	TAX
	LDY	TEMP+1,X	;GET 1ST BLOCK TYPE
	LDX	#20		;SET INITIAL BOTTOM OF WINDOW
	JSR	JUMPVEC
	LDA	TEMP		;MUST FINISH THIS ONE!
	SEC
	SBC	#$01
	AND	#$03		;GET NEXT BLOCK NUMBER
	TAY
	LDA	TEMP+1,Y
	TAY
	JSR	JLINE0		;X STAYS INTACT, CALL FIRST LINE THIS TIME
	BMI	.9		;IF DONE THEN EXIT
	LDA	TEMP
	SEC
	SBC	#$02
	AND	#$03		;GET 3RD BLOCK IF NECESSARY
	TAY
	LDA	TEMP+1,Y	;THIS ONE ALWAYS FINISHES 
	TAY
	JSR	JLINE0
.9:
	JMP	KBANK
JUMPVEC:
	JMP	(ADPF0) 	;JUMP TO PORTION OF PROGRAM
****
*
* PROGRAM TO ERASE MEN FROM SCREEN
*
****
ERAGUYS:
	LDA	#$00
	TAX
	CLC
.0:
	LDY	PLVER+6+SARA,X
	BEQ	.01
	SEC
.01:
	ROL
	INX
	CPX	#$04
	BNE	.0
	STA	TEMP
	LDA	ROOM
	SEC
	SBC	OBSTAT+SARA
	TAX
	LSR
	TAY
	LDA	OBJMASK,X	;PUT STATUS OF ROOM INTO RAM
	BPL	.02
	LDA	TEMP
	ASL
	ASL
	ASL
	ASL
	STA	TEMP
.02:
	LDA	OBSTAT+1+SARA,Y
	AND	OBJMASK+1,X
	ORA	TEMP
	STA	OBSTAT+1,Y
	LDX	#$09
	LDA	#$00
.1:
	STA	TOTLIN,X
	STA	PLVER,X
	DEX
	BPL	.1
	STA	COLOR
	STA	COLOR+1 
	STA	AUDV0
	STA	AUDV0+1
	STA	SOUND0
	STA	SOUND0+1
	LDX	#20
.2:
	STA	RAMPF0,X
	STA	RAMPF1,X
	STA	RAMPF2,X
	DEX
	BPL	.2
	LDA	CONTRL
	AND	#$F0
	ORA	#$03
	STA	CONTRL
	LDX	#$01
.3:
	LDA	SCORHI,X
	CMP	SCORHI+2	;UPDATE HIGH SCORE
	BCC	.5
	BNE	.4
	LDA	SCORLO,X
	CMP	SCORLO+2
	BCC	.5
.4:
	LDA	SCORHI,X
	STA	SCORHI+2
	LDA	SCORLO,X
	STA	SCORLO+2
.5:
	DEX
	BPL	.3
	JMP	KBANK
****
*
* PROGRAM TO PUT GUYS ON SCREEN
*
****
PUTGUYS:
	LDA	LEVEL
	LSR
	AND	#$0C
	STA	TEMP
	LDA	PLAY		;DIFICULTY BITS AND LEVEL
	LSR
	ORA	TEMP
	STA	TEMP
	TAX
	LDA	MUTATE,X	;DETERMINE GROUP TO MAKE	
	STA	TEMP+1
	LDX	IT
	LDA	PLHOR+SARA,X	;GET PLAYER POSITIONS 
	STA	TEMP+4
	LDA	PLVER+SARA,X
	AND	#$C0
	STA	TEMP+5
	LDX	TEMP
	LDA	GENS,X		;GET DIFICULTY FOR PUTING ENEMY CLOSE TO
	STA	TEMP		;PLAYERS
	LDY	#$03
.1:
	TYA
	CLC			;TO TYPE OF PLAYER AND HITS TO KILL
	ADC	TEMP+1		;ADD PLAYER NUMBER TO BEG OF GROUP
	TAX
	LDA	GENGUY,X	;GET TYPE
	TAX
	AND	#$F0
	STA	PLTYP+2,Y
	TXA
	AND	#$0F
	STA	PLREF+2,Y	;HIT BITS
	JSR	GETRAND
	AND	#$C7
	STA	TEMP+2		;SET INITIAL FOR ENEMY POSITION
	JSR	GETRAND
	AND	TEMP		;CHECK IF ABLE TO MOVE PLAYER CLOSER
	BNE	.3
	LDA	TEMP+2
	LDX	TEMP+4
	BPL	.2
	ORA	#$04		;MOVE TO RIGHT SIDE
	STA	TEMP+2
	BNE	.3
.2:
	AND	#$C3
	STA	TEMP+2		;MOVE TO LEFT SIDE
.3:
	JSR	GETRAND
	AND	TEMP		;CHECK IF ABLE TO DO
	BNE	.4
	LDA	TEMP+2		;PUT ENEMY IN SAME BLOCK AS PLAYERS
	AND	#$07
	ORA	TEMP+5
	STA	TEMP+2
.4:
	LDA	TEMP+2
	AND	#$07
	TAX
	LDA	ENEMX,X 	;FIND HORIZONTAL LOCATION
	STA	PLHOR+2,Y
	LDA	ENEMY,X 	;FIND VERTICAL LOCATION
	ORA	TEMP+2
	AND	#$F0
	STA	PLVER+2,Y
	DEY
	BPL	.1		;LOOP THROUGH ENEMIES	  
PUTOBJ:
	LDA	#$00
	STA	ADPF0
	STA	ADPF0+1
	LDA	ROOM
	ASL
	ROL	ADPF0+1 	;ADDRESS=OBJECTS+ROOM*8
	ASL
	ROL	ADPF0+1
	ASL
	ROL	ADPF0+1
	ADC	#OBJECTS&$FF
	STA	ADPF0
	LDA	ADPF0+1
	ADC	#OBJECTS/256
	STA	ADPF0+1
	LDY	#$03
.1:
	LDA	(ADPF0),Y
	TAX
	AND	#$0F
	STA	PLTYP+6,Y	;DO OBJECT TYPES
	TXA
	AND	#$F0
	STA	PLREF+6,Y
	DEY
	BPL	.1
	
	LDA	ROOM
	SEC
	SBC	OBSTAT+SARA
	TAX
	LSR
	TAY
	LDA	OBSTAT+1+SARA,Y	  
	AND	OBJMASK,X
	CMP	#$10
	BCC	.2
	LSR
	LSR
	LSR
	LSR
.2:
	STA	TEMP+2
	LDY	#$07
.3:
	LSR	TEMP+2		;SHIFT STATUS OF OBJECT INTO CARRY
	BCC	.4    
	LDA	(ADPF0),Y	;GET LOCATION BYTE
	STA	TEMP
	AND	#$0F
	TAX
	LDA	OBJX,X
	STA	PLHOR+2,Y
	LDA	TEMP
	AND	#$C0
	ORA	OBJY,X
	STA	PLVER+2,Y
.4:
	DEY
	BPL	.3
	LDA	CONTRL
	AND	#$F0
	ORA	#$06
	STA	CONTRL
	LDA	#$03
	STA	FRMCNT
	JMP	KBANK
JLINE0:
	LDA	PF0TAB,Y
	STA	RAMPF0,X
	LDA	PF1TAB,Y
	STA	RAMPF1,X
	LDA	PF2TAB,Y
	STA	RAMPF2,X
	DEX
	BMI	JEXIT1
JLINE1:
	LDA	PF0TAB+16,Y
	STA	RAMPF0,X
	LDA	PF1TAB+16,Y
	STA	RAMPF1,X
	LDA	PF2TAB+16,Y
	STA	RAMPF2,X
	DEX
	BMI	JEXIT1
JLINE2:
	LDA	PF0TAB+32,Y
	STA	RAMPF0,X
	LDA	PF1TAB+32,Y
	STA	RAMPF1,X
	LDA	PF2TAB+32,Y
	STA	RAMPF2,X
	DEX
	BMI	JEXIT1
JLINE3:
	LDA	PF0TAB+48,Y
	STA	RAMPF0,X
	LDA	PF1TAB+48,Y
	STA	RAMPF1,X
	LDA	PF2TAB+48,Y
	STA	RAMPF2,X
	DEX
	BMI	JEXIT1
JLINE4:
	LDA	PF0TAB+64,Y
	STA	RAMPF0,X
	LDA	PF1TAB+64,Y
	STA	RAMPF1,X
	LDA	PF2TAB+64,Y
	STA	RAMPF2,X
	DEX
	BMI	JEXIT1
JLINE5:
	LDA	PF0TAB+80,Y
	STA	RAMPF0,X
	LDA	PF1TAB+80,Y
	STA	RAMPF1,X
	LDA	PF2TAB+80,Y
	STA	RAMPF2,X
	DEX
	BPL	JLINE6
JEXIT1:
	RTS
JLINE6:
	LDA	PF0TAB+96,Y
	STA	RAMPF0,X
	LDA	PF1TAB+96,Y
	STA	RAMPF1,X
	LDA	PF2TAB+96,Y
	STA	RAMPF2,X
	DEX
	BMI	JEXIT1
JLINE7:
	LDA	PF0TAB+112,Y
	STA	RAMPF0,X
	LDA	PF1TAB+112,Y
	STA	RAMPF1,X
	LDA	PF2TAB+112,Y
	STA	RAMPF2,X
	DEX
	BMI	JEXIT1
JLINE8:
	LDA	PF0TAB+128,Y
	STA	RAMPF0,X
	LDA	PF1TAB+128,Y
	STA	RAMPF1,X
	LDA	PF2TAB+128,Y
	STA	RAMPF2,X
	DEX
	BMI	JEXIT1
JLINE9:
	LDA	PF0TAB+144,Y
	STA	RAMPF0,X
	LDA	PF1TAB+144,Y
	STA	RAMPF1,X
	LDA	PF2TAB+144,Y
	STA	RAMPF2,X
	DEX
	BMI	JEXIT1
JLINEA:
	LDA	PF0TAB+160,Y
	STA	RAMPF0,X
	LDA	PF1TAB+160,Y
	STA	RAMPF1,X
	LDA	PF2TAB+160,Y
	STA	RAMPF2,X
	DEX
	BMI	JEXIT1
JLINEB:
	LDA	PF0TAB+176,Y
	STA	RAMPF0,X
	LDA	PF1TAB+176,Y
	STA	RAMPF1,X
	LDA	PF2TAB+176,Y
	STA	RAMPF2,X
	DEX
	BMI	JEXIT2
JLINEC:
	LDA	PF0TAB+192,Y
	STA	RAMPF0,X
	LDA	PF1TAB+192,Y
	STA	RAMPF1,X
	LDA	PF2TAB+192,Y
	STA	RAMPF2,X
	DEX
	BMI	JEXIT2
JLINED:
	LDA	PF0TAB+208,Y
	STA	RAMPF0,X
	LDA	PF1TAB+208,Y
	STA	RAMPF1,X
	LDA	PF2TAB+208,Y
	STA	RAMPF2,X
	DEX
	BMI	JEXIT2
JLINEE:
	LDA	PF0TAB+224,Y
	STA	RAMPF0,X
	LDA	PF1TAB+224,Y
	STA	RAMPF1,X
	LDA	PF2TAB+224,Y
	STA	RAMPF2,X
	DEX
	BMI	JEXIT2
JLINEF:
	LDA	PF0TAB+240,Y
	STA	RAMPF0,X
	LDA	PF1TAB+240,Y
	STA	RAMPF1,X
	LDA	PF2TAB+240,Y
	STA	RAMPF2,X
	DEX
JEXIT2:
	RTS
****
*
* WILL WRITE TO THE KERNAL REGISTERS CONCERNING THE PLAYERS TO BE
* DRAWN THIS TURN
* 
* MEMORY LOCATIONS USED:
* TEMP	LINE COUNTER
* TEMP+1	MAX NUMBER OF PLAYERS ON LINE TO ADD TO CURRENT
* TEMP+5       COUNTER TO PLAYER IN PLYTAB
* 
****
UPLAY:
	LDX	#$00
	LDA	#$FF
	STX	TEMP
	STA	LTYPE,X 	;FIRST LINE = FF (BOTH RESET)
	STX	TEMP+5
	LDA	WINDOW
	AND	#$F0
	STA	TEMP+2
	JMP	.3
.1:
	LDA	LTYPE,X 	;CHECK TYPE OF LINE
	BEQ	.3
	BMI	.2
	CMP	#$01
	BEQ	.15
	LDA	#$00
	STA	TEMP+1
	BEQ	.6		;IF RESET NONE NEXT LINE = BOTH
.15:
	LDA	#$06		;P1 RESET PORTION
	JSR	GETPLAY 	;LOAD P1 INFORMATION
	BMI	.55		;IF NO REQUEST THEN DONE
	LDA	#$FF		;IF REQUEST THEN P0 RESET
	BMI	.6
.2:
	LDA	#$00		;P0 RESET PORTION
	JSR	GETPLAY 	;LOAD P0 INFORMATION
	BMI	.55
	LDA	#$01		;IF REQUEST THEN P1 RESET
	BNE	.6
.3:
	LDA	#$00		;BOTH RESET PORTION
	JSR	GETPLAY 	;LOAD P0 INFORMATION
	STA	TEMP+4		;STORE REQUEST INFORMATION
	LDA	#$06		;GET P1 INFORMATION
	JSR	GETPLAY
	BPL	.4		;IF REQUEST SKIP
	LDA	TEMP+4		;IF P0=NO P1=NO THEN X IS OK
	BMI	.55
	LDA	#$01		;IF P1=NO P0=YES THEN P1 RESET
	BNE	.6
.4:
	LDA	TEMP+4		;IF P0=YES P1=YES THEN SKIP
	BPL	.5
	LDA	#$FF		;IF P1=YES P0=NO THEN P0 RESET
	BMI	.6
.5:
	LDA	TOTLIN+1,X
	BNE	.51
	LDA	#$02
	BNE	.6
.51:
	LDA	#$70		;IF BOTH REQUEST THEN CLEAR OUT P1 VOFFSET
	STA	VERTP0,Y
	DEC	CURLIN,X	;DECREMENT CURRENT PLAYER COUNTER
	LDA	#$01		;SET FOR P1 RESET
	BNE	.6
.55:
	LDA	#$00
.6:
	INX			;A= NEXT LINE'S INFORMATION
	CPX	#$06		;INCREMENT LINE COUNTER
	BEQ	.7		;IF = 0 THEN EXIT
	STX	TEMP
	STA	LTYPE,X 	;STORE INFORMATION ON NEXT LINE
	LDA	TEMP+2
	CLC
	ADC	#$10
	STA	TEMP+2
	LDA	TEMP+1
	CLC
	ADC	TEMP+5		;ADD NUMBER OF PLAYERS IN LINE TO COUNTER
	STA	TEMP+5
	BCC	.1		;LOOP BACK
.7:
	RTS
****
*
* GET PLAYER INFORMATION USING PLYTAB AND CURRENT LINE
* ON ENTRY
*  A = PLAYER 0=PLAYER0 8=PLAYER1
*  X = TEMP = LINE NUMBER
* ON EXIT
*  A = PLYTAB BIT 7 0=REQUEST 1=NO REQUEST
*  Y = PLAYER OFFSET  PLAYER+LINE#
*  X = TEMP (LINE COUNTER)
*
* LOCATIONS USED:
* TEMP	LINE COUNTER (REFERENCE)
* TEMP+1	NUMBER OF PLAYERS ON LINE
* TEMP+2	PLYTAB INFORMATION
* TEMP+3	OFFSET TO PLAYER IN KERNAL
* COUNTER	USED TO OBTAIN ADDRESS OF PLAYER IN PLYTAB
*
****
GETPLAY:
	CLC
	ADC	TEMP		;CALC OFFSET IN KERNAL LOCATIONS
	STA	TEMP+3		;TEMP+3 = LINE+PLAYER
	LDA	TOTLIN,X	;GET NUMBER OF PLAYERS IN LINE
	STA	TEMP+1
	BNE	.1
	LDY	TEMP+3		;ALSO CLEAR OUT PLAYER
	LDA	#$33
	STA	HORIP0,Y
	LDA	#$70
	STA	VERTP0,Y	;RETURN WITH SIGN BIT SET AND Y = OFFSET
	LDA	#$FF
	RTS
.1:
	LDA	CURLIN,X	;GET CURRENT VALUE
	CMP	TEMP+1		;CHECK AGAINST MAX VALUE
	BNE	.2
	LDA	#$00		;IF CURRENT = MAX THEN CURRENT = 0
.2:
	CLC
	STA	CURLIN,X	;STORE IN TABLE
	ADC	TEMP+5		;ADD TO OFFSET IN PLYTAB
	TAX
	LDA	PLYTAB+SARA,X	;LOAD PLAYER INFORMATION
	TAY
	LDA	PLHOR+SARA,Y
	LDX	TEMP+3
	STA	HORIP0,X
	LDA	PLTYP+SARA,Y
	STA	PTYPE0,X
	LDA	PLREF+SARA,Y
	STA	PLREF0,X
	LDA	PLVER+SARA,Y
	SEC
	SBC	TEMP+2
	STA	VERTP0,X
	BEQ	.25
	BMI	.25
	LDY	TEMP+3
	LDX	TEMP
	INC	CURLIN,X
	LDA	#$00
	RTS
.25:
	LDY	TEMP+3
	LDX	TEMP
	INC	CURLIN,X
	LDA	#$FF
	RTS
GETRAND:
	LDA	RANDOM
	CLC
	ADC	#$41
	STA	RANDOM
	RTS
UPCOLOR:
	LDA	PLVER+1+SARA
	ASL
	STA	COLOR+1
	RTS
* DATA FOR PROGRAM JUMP LOCATIONS
JLO:
	DC.B	JLINEF&$FF,JLINEE&$FF,JLINED&$FF,JLINEC&$FF
	DC.B	JLINEB&$FF,JLINEA&$FF,JLINE9&$FF,JLINE8&$FF
	DC.B	JLINE7&$FF,JLINE6&$FF,JLINE5&$FF,JLINE4&$FF
	DC.B	JLINE3&$FF,JLINE2&$FF,JLINE1&$FF,JLINE0&$FF
JHI:
	DC.B	JLINEF/256,JLINEE/256,JLINED/256,JLINEC/256
	DC.B	JLINEB/256,JLINEA/256,JLINE9/256,JLINE8/256
	DC.B	JLINE7/256,JLINE6/256,JLINE5/256,JLINE4/256
	DC.B	JLINE3/256,JLINE2/256,JLINE1/256,JLINE0/256
* GRAPHICS FOR CELLS 16*16*3 = 768 BYTES
PF0TAB:
	DC.B	$30,$30,$30,$30,$30,$30,$30,$30,$30,$30,$30,$30,$30,$30,$30,$30
	DC.B	$30,$30,$30,$30,$30,$30,$30,$30,$30,$30,$30,$30,$30,$30,$30,$30
	DC.B	$30,$30,$30,$30,$30,$30,$30,$30,$30,$30,$30,$30,$30,$30,$30,$30
	DC.B	$30,$30,$30,$30,$30,$30,$30,$30,$30,$30,$30,$30,$30,$30,$30,$30
	DC.B	$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	DC.B	$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	DC.B	$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
	DC.B	$30,$30,$30,$30,$30,$30,$30,$30,$30,$30,$30,$30,$30,$30,$30,$30
	DC.B	$30,$30,$30,$30,$30,$30,$30,$30,$30,$30,$30,$30,$30,$30,$30,$30
	DC.B	$30,$30,$30,$30,$30,$30,$30,$30,$30,$30,$30,$30,$30,$30,$30,$30
	DC.B	$30,$30,$30,$30,$30,$30,$30,$30,$30,$30,$30,$30,$30,$30,$30,$30
	DC.B	$30,$30,$30,$30,$30,$30,$30,$30,$30,$30,$30,$30,$30,$30,$30,$30
	DC.B	$30,$30,$30,$30,$30,$30,$30,$30,$30,$30,$30,$30,$30,$30,$30,$30
	DC.B	$30,$30,$30,$30,$70,$70,$70,$70,$70,$30,$70,$30,$70,$30,$70,$30
	DC.B	$30,$30,$30,$30,$F0,$F0,$F0,$F0,$F0,$30,$F0,$30,$F0,$30,$F0,$30
	DC.B	$30,$30,$30,$30,$F0,$F0,$F0,$F0,$F0,$30,$F0,$30,$F0,$30,$F0,$30
PF1TAB:
	DC.B	$00,$00,$06,$06,$00,$00,$06,$06,$00,$00,$00,$00,$06,$06,$06,$06
	DC.B	$00,$00,$06,$06,$00,$00,$06,$06,$00,$00,$00,$00,$06,$06,$06,$06
	DC.B	$00,$00,$06,$06,$00,$00,$06,$06,$00,$00,$00,$00,$06,$06,$06,$06
	DC.B	$00,$00,$06,$06,$00,$00,$06,$06,$00,$00,$00,$00,$06,$06,$06,$06
	DC.B	$00,$00,$06,$06,$00,$00,$06,$06,$00,$00,$00,$00,$06,$06,$06,$06
	DC.B	$00,$00,$06,$06,$00,$00,$06,$06,$00,$00,$00,$00,$06,$06,$06,$06
	DC.B	$00,$00,$06,$06,$00,$00,$06,$06,$00,$00,$00,$00,$06,$06,$06,$06
	DC.B	$00,$00,$06,$06,$00,$00,$06,$06,$00,$00,$00,$00,$06,$06,$06,$06
	DC.B	$00,$00,$06,$06,$00,$00,$06,$06,$00,$00,$00,$00,$06,$06,$06,$06
	DC.B	$00,$00,$06,$06,$00,$00,$06,$06,$00,$00,$00,$00,$06,$06,$06,$06
	DC.B	$00,$00,$06,$06,$00,$00,$06,$06,$00,$00,$00,$00,$06,$06,$06,$06
	DC.B	$00,$00,$06,$06,$00,$00,$06,$06,$00,$00,$00,$00,$06,$06,$06,$06
	DC.B	$00,$00,$06,$06,$00,$00,$06,$06,$00,$00,$00,$00,$06,$06,$06,$06
	DC.B	$00,$00,$06,$06,$00,$00,$0F,$0F,$00,$00,$00,$00,$0E,$07,$0E,$07
	DC.B	$00,$00,$06,$06,$FF,$FF,$FF,$FF,$FE,$07,$FE,$07,$FE,$07,$FE,$07
	DC.B	$00,$00,$06,$06,$FF,$FF,$FF,$FF,$FE,$07,$FE,$07,$FE,$07,$FE,$07
PF2TAB:
	DC.B	$00,$80,$00,$80,$00,$80,$00,$80,$00,$00,$80,$80,$00,$00,$80,$80
	DC.B	$00,$80,$00,$80,$00,$80,$00,$80,$00,$00,$80,$80,$00,$00,$80,$80
	DC.B	$00,$80,$00,$80,$00,$80,$00,$80,$00,$00,$80,$80,$00,$00,$80,$80
	DC.B	$00,$80,$00,$80,$00,$80,$00,$80,$00,$00,$80,$80,$00,$00,$80,$80
	DC.B	$00,$80,$00,$80,$00,$80,$00,$80,$00,$00,$80,$80,$00,$00,$80,$80
	DC.B	$00,$80,$00,$80,$00,$80,$00,$80,$00,$00,$80,$80,$00,$00,$80,$80
	DC.B	$00,$80,$00,$80,$00,$80,$00,$80,$00,$00,$80,$80,$00,$00,$80,$80
	DC.B	$00,$80,$00,$80,$00,$80,$00,$80,$00,$00,$80,$80,$00,$00,$80,$80
	DC.B	$00,$80,$00,$80,$00,$80,$00,$80,$00,$00,$80,$80,$00,$00,$80,$80
	DC.B	$00,$80,$00,$80,$00,$80,$00,$80,$00,$00,$80,$80,$00,$00,$80,$80
	DC.B	$00,$80,$00,$80,$00,$80,$00,$80,$00,$00,$80,$80,$00,$00,$80,$80
	DC.B	$00,$80,$00,$80,$00,$80,$00,$80,$00,$00,$80,$80,$00,$00,$80,$80
	DC.B	$00,$80,$00,$80,$00,$80,$00,$80,$00,$00,$80,$80,$00,$00,$80,$80
	DC.B	$00,$80,$00,$80,$00,$C0,$00,$C0,$00,$00,$80,$C0,$00,$00,$80,$C0
	DC.B	$00,$80,$00,$80,$FF,$FF,$FF,$FF,$00,$FF,$80,$FF,$00,$FF,$80,$FF
	DC.B	$00,$80,$00,$80,$FF,$FF,$FF,$FF,$00,$FF,$80,$FF,$00,$FF,$80,$FF
****
*
* POINTER FOR ROOMS TO PF DATA
*
****
* DATA FOR TYPE OF CELLS 2*82 = 164 BYTES
BTYPE:
* A 0
	DC.B	$40,$19
* B 1
	DC.B	$51,$2A
* C 2
	DC.B	$61,$8B,$71,$08
* D 4
	DC.B	$7A,$92,$51,$4A
* E 6
	DC.B	$73,$AB,$45,$24
* F 8
	DC.B	$7E,$A1,$61,$A4
* G A
	DC.B	$40,$00,$5A,$4E,$54,$44
* H D
	DC.B	$6A,$A5,$44,$52,$63,$A4
* I 10
	DC.B	$78,$50,$45,$0C,$60,$54
* J 13
	DC.B	$44,$6A,$45,$14,$73,$A1
* K 16
	DC.B	$45,$EE,$63,$A8,$44,$14
* L 19
	DC.B	$51,$FA,$68,$44,$45,$CB
* M 1C
	DC.B	$5E,$A4,$44,$51,$51,$40
* N 1F
	DC.B	$5E,$AE,$6A,$B8,$45,$C9
* O 22
	DC.B	$55,$EA,$51,$70,$5C,$B4
* P 25
	DC.B	$45,$14,$62,$84,$44,$EB
* Q 28
	DC.B	$44,$44,$44,$44,$5E,$A4,$41,$5B
* R 2C
	DC.B	$5E,$3A,$42,$44,$44,$E8,$5E,$A4
* S 30
	DC.B	$47,$3A,$70,$54,$44,$44,$5E,$A1
* T 34
	DC.B	$55,$55,$44,$44,$40,$40,$44,$04
* U 38
	DC.B	$73,$3A,$44,$68,$4E,$34,$44,$51
* V 3C
	DC.B	$5E,$3A,$5E,$A4,$4C,$2A,$5E,$A4
* W 40
	DC.B	$55,$44,$45,$15,$40,$54,$44,$1B
* X 44
	DC.B	$5E,$3A,$45,$45,$44,$14,$44,$51
* Y 48
	DC.B	$55,$11,$51,$44,$44,$05,$51,$44
* Z 4C
	DC.B	$45,$11,$45,$54,$51,$14,$44,$54
OBJMASK:
	DC.B	$F0,$0F,$F0,$0F,$F0
SCORES:
	DC.B	$01,$02,$03,$05,$10
MUTATE:
	DC.B	$00,$05,$07,$00,$01,$07,$0A,$00
	DC.B	$02,$09,$0A,$00,$04,$0C,$0C,$00
GENGUY:
	DC.B	$31,$41,$31,$41,$51,$31,$41,$51
	DC.B	$62,$52,$72,$62,$53,$63,$73,$73
GENSPEED:
	DC.B	$00,$00,$01,$00,$01,$03,$07,$00
	DC.B	$03,$07,$0F,$00,$07,$0F,$1F,$00
GENS:
	DC.B	$0F,$0F,$07,$00,$0F,$07,$03,$00
	DC.B	$0F,$03,$03,$00,$07,$03,$01,$00
ENEMX:
	DC.B	$0C,$1B,$0C,$38,$8C,$7D,$8C,$60
ENEMY:
	DC.B	$10,$20,$30,$10,$10,$20,$30,$30
OBJX:
	DC.B	$00,$18,$30,$40,$58,$68,$80,$18
	DC.B	$30,$40,$58,$68,$80,$01,$97,$00
OBJY:
	DC.B	$00,$10,$10,$10,$10,$10,$10,$30
	DC.B	$30,$30,$30,$30,$30,$20,$20,$00
OBJECTS:
* A 
	DC.B	$0E,$01,$0A,$0A,$CC,$46,$89,$0E
* B 
	DC.B	$EF,$0A,$09,$0A,$01,$0A,$C9,$8D
* C 
	DC.B	$BF,$01,$0A,$00,$CA,$81,$4A,$00
	DC.B	$0E,$AF,$0A,$00,$43,$CC,$C1,$00
* D 
	DC.B	$0E,$05,$BF,$00,$07,$06,$CB,$00
	DC.B	$DF,$1F,$CF,$00,$0D,$4A,$C9,$00
* E 
	DC.B	$EF,$5F,$08,$00,$CA,$0A,$45,$00
	DC.B	$9F,$0A,$01,$AF,$0D,$44,$88,$C9
* F 
	DC.B	$CF,$EF,$01,$02,$01,$0C,$47,$46
	DC.B	$0D,$9F,$0B,$00,$4D,$8A,$CB,$00
* G 
	DC.B	$0D,$0A,$0A,$9F,$0D,$C1,$C7,$CE
	DC.B	$8F,$8F,$0B,$03,$01,$07,$C7,$C6
	DC.B	$CF,$EF,$CF,$DF,$01,$0E,$4C,$CD
* H 
	DC.B	$02,$0C,$EF,$8F,$06,$47,$C7,$CE
	DC.B	$5F,$1F,$1F,$AF,$06,$07,$84,$C8
	DC.B	$0C,$02,$AF,$BF,$02,$89,$C8,$CC
* I 
	DC.B	$6F,$01,$BF,$1F,$01,$0B,$84,$C3
	DC.B	$0C,$03,$0E,$8F,$06,$43,$C7,$CE
	DC.B	$DF,$AF,$AF,$DF,$0E,$83,$89,$CD
* J 
	DC.B	$CF,$DF,$6F,$0E,$0C,$4E,$87,$86
	DC.B	$08,$AF,$0D,$8F,$0E,$44,$8D,$C6
	DC.B	$2F,$3F,$CF,$BF,$02,$0B,$43,$C9
* K 
	DC.B	$0C,$4F,$6F,$EF,$43,$8A,$C5,$CA
	DC.B	$BF,$AF,$DF,$0C,$02,$0C,$4D,$CC
	DC.B	$DF,$DF,$0A,$0C,$0E,$4D,$8A,$C6
* L 
	DC.B	$0C,$AF,$DF,$04,$04,$4A,$8D,$82
	DC.B	$AF,$0E,$8F,$3F,$01,$0C,$4D,$47
	DC.B	$AF,$08,$9F,$BF,$0C,$8E,$CE,$C9
* M 
	DC.B	$8F,$8F,$EF,$6F,$41,$4D,$47,$C1
	DC.B	$0C,$0B,$3F,$1F,$41,$4C,$84,$C9
	DC.B	$0A,$0A,$5F,$DF,$03,$09,$4A,$8E
* N 
	DC.B	$AF,$EF,$AF,$0C,$04,$46,$C4,$CC
	DC.B	$7F,$01,$DF,$9F,$06,$49,$8E,$CE
	DC.B	$4F,$08,$08,$0A,$07,$8D,$CD,$CC
* O 
	DC.B	$0C,$0E,$7F,$08,$09,$87,$86,$CD
	DC.B	$0B,$0A,$6F,$5F,$04,$49,$83,$8A
	DC.B	$0A,$8F,$DF,$09,$48,$4E,$8E,$CD
* P 
	DC.B	$2F,$5F,$0A,$8F,$01,$0A,$89,$CE
	DC.B	$4F,$EF,$7F,$9F,$02,$09,$C7,$CE
	DC.B	$8F,$DF,$6F,$0C,$01,$0E,$89,$CB
* Q 
	DC.B	$8F,$8F,$8F,$7F,$0D,$82,$8A,$CB
	DC.B	$9F,$EF,$8F,$9F,$0B,$48,$C6,$CB
	DC.B	$7F,$1F,$5F,$9F,$41,$4C,$89,$C4
	DC.B	$4F,$1F,$8F,$8F,$06,$84,$C2,$C8
* R 
	DC.B	$03,$BF,$1F,$BF,$01,$0A,$C1,$CB
	DC.B	$AF,$AF,$4F,$8F,$04,$0A,$8C,$CC
	DC.B	$3F,$0C,$2F,$2F,$07,$87,$86,$C8
	DC.B	$AF,$EF,$6F,$1F,$4D,$46,$88,$C7
* S 
	DC.B	$0E,$0A,$0A,$0A,$44,$8B,$C5,$CB
	DC.B	$5F,$0C,$8F,$0D,$02,$8A,$8E,$CD
	DC.B	$1F,$2F,$3F,$4F,$08,$48,$88,$C8
	DC.B	$9F,$9F,$0A,$0B,$4D,$4E,$C8,$C4
* T 
	DC.B	$EF,$0C,$9F,$8F,$44,$89,$8E,$CE
	DC.B	$0A,$DF,$9F,$8F,$08,$4D,$8E,$CE
	DC.B	$3F,$DF,$9F,$8F,$06,$4D,$9E,$CE
	DC.B	$0C,$1F,$6F,$9F,$0C,$46,$8C,$CD
* U 
	DC.B	$0E,$03,$02,$1F,$02,$08,$42,$CA
	DC.B	$0B,$1F,$7F,$5F,$0B,$47,$87,$86
	DC.B	$1F,$8F,$4F,$0C,$43,$4B,$82,$8A
	DC.B	$0A,$9F,$DF,$03,$07,$8E,$CE,$C9
* V 
	DC.B	$06,$07,$05,$04,$82,$88,$C9,$C4
	DC.B	$04,$04,$07,$03,$4D,$46,$89,$84
	DC.B	$02,$04,$01,$03,$02,$0A,$42,$C8
	DC.B	$01,$EF,$04,$01,$04,$41,$4C,$89
* W 
	DC.B	$9F,$9F,$7F,$9F,$0D,$0E,$44,$CD
	DC.B	$8F,$DF,$CF,$CF,$0E,$8E,$C3,$CB
	DC.B	$DF,$EF,$02,$AF,$4D,$83,$8A,$CA
	DC.B	$9F,$8F,$AF,$AF,$0D,$4E,$89,$C4
* X 
	DC.B	$08,$CF,$AF,$0A,$0D,$46,$86,$CA
	DC.B	$0C,$9F,$0C,$EF,$4B,$CD,$C9,$C4
	DC.B	$08,$DF,$DF,$8F,$0D,$4D,$CD,$CE
	DC.B	$8F,$9F,$8F,$DF,$0D,$4E,$8D,$CD
* Y 
	DC.B	$0A,$0A,$0C,$8F,$03,$09,$44,$CE
	DC.B	$8F,$1F,$1F,$8F,$4E,$86,$8C,$CE
	DC.B	$7F,$5F,$EF,$8F,$03,$0A,$C8,$CE
	DC.B	$0A,$0A,$0D,$8F,$04,$0A,$CD,$CE
* Z 
	DC.B	$5F,$BF,$2F,$8F,$06,$43,$89,$CE
	DC.B	$8F,$8F,$EF,$8F,$4D,$4E,$8D,$8E
	DC.B	$6F,$03,$7F,$DF,$03,$83,$8A,$CD
	DC.B	$1F,$4F,$0C,$8F,$07,$89,$84,$CE









